# -*- coding: utf-8 -*-
"""
Парсер для cbar.az.
"""
from stocks3.parsers.xml import NewXMLParser
from stocks3.core.factories import parsers
from stocks3.core.common import get_field


class CbarAzParser(NewXMLParser):
    def parse(self, place):
        NewXMLParser.parse(self, place)

        date = get_field(self.data, 'ValCurs.@Date', False)
        quotes_array = get_field(self.data, 'ValCurs.ValType.1.Valute', True, default=[])

        for quote in quotes_array:
            value = float(quote['Value'])  # if quote['dir'] != '1' else 1 / float(quote['val'])
            price = self.default_map.make_price_date(quote['@Code'], date, value)
            if price is not None:
                yield price


parsers.register("stocks3.parsers.CbarAz", CbarAzParser)
