# -*- coding: utf-8 -*-
"""
Парсер для cbr.ru.
"""
from stocks3.parsers.xml import XMLParser
from stocks3.core.factories import parsers


class CbrRuParser(XMLParser):
    def parse(self, place):
        XMLParser.parse(self, place)
        source_date = self.dataRoot.get('Date')
        for item in self.findall('Valute'):
            source_quote_id = item.findtext('CharCode')
            quote_scale = float(item.findtext('Nominal'))
            value = float(item.findtext('Value').replace(',', '.'))
            value /= quote_scale
            price = self.default_map.make_price_date(source_quote_id, source_date, value)
            if price is not None:
                yield price

parsers.register("stocks3.parsers.CbrRu", CbrRuParser)

