# -*- coding: utf-8 -*-

"""
Парсер для cbr.ru.
"""
from __future__ import print_function
__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


from stocks3.parsers.xml import XMLParser
from stocks3.core.factories import parsers


class CbrMetalsParser(XMLParser):
    def parse(self, place):
        XMLParser.parse(self, place)
        for item in self.findall('Record'):
            source_date = item.get('Date')
            source_quote_id = item.get('Code')
            buy_value = float(item.findtext('Buy').replace(',', '.'))
            # sell_value = float(item.findtext('Sell').replace(',', '.'))
            price = self.default_map.make_price_date(source_quote_id, source_date, buy_value)
            if price is not None:
                yield price

parsers.register("stocks3.parsers.CbrMetals", CbrMetalsParser)

