# -*- coding: utf-8 -*-

"""
Парсим турецкий сайт с валютами - tcmb.gov.tr.
"""
from __future__ import print_function
__author__ = "Bogdanov Evgeniy"
__email__ = "evbogdanov@yandex-team.ru"

from stocks3.parsers.jsonp import JSONParser
from stocks3.core.factories import parsers
from stocks3.share.db import DB_PRECISION


class DovizParser(JSONParser):

    def makeConfig(self):
        JSONParser.makeConfig(self)
        self.tags = {}

    def parse(self, place):
        JSONParser.parse(self, place)

        for quote in self.datatree:
            sourceQuoteId = str(quote["parity"])
            sourceDate = str(quote["date"] + ' ' + quote['time'])
            try:
                buy_value = quote["selling"]
                sell_value = quote["buying"]
            except KeyError:
                # FIXME: очень трудно будет понять, почему не работает парсер
                continue
            buy_value = round(float(buy_value), DB_PRECISION)
            sell_value = round(float(sell_value), DB_PRECISION)
            price = self.default_map.make_dual_price_date(sourceQuoteId, sourceDate, buy_value, sell_value)
            if price is not None:
                yield price


parsers.register("stocks3.parsers.Doviz", DovizParser)

