# -*- coding: utf-8 -*-

"""
Парсим Mosprice.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"

from stocks3.parsers.xml import XMLParser
from stocks3.core.factories import parsers


class DsIfxMosprimeParser(XMLParser):

    def parse(self, place):
        XMLParser.parse(self, place)
        for item in self.dataRoot.findall("ITEM"):
            sourceQuoteId = item.attrib["id"]
            sourceDate = item.attrib["date"]
            value = float(item.attrib["closeprice"].replace(",", "."))
            price = self.default_map.make_price_date(sourceQuoteId, sourceDate, value)
            if price is not None:
                yield price


parsers.register("stocks3.parsers.DsIfxMosprime", DsIfxMosprimeParser)

