# -*- coding: utf-8 -*-
"""
Парсим данные от ecb.europa.eu.
"""
from __future__ import print_function
from stocks3.parsers.xml import XMLParser
from stocks3.core.factories import parsers


class EcbParser(XMLParser):
    def parse(self, place):
        XMLParser.parse(self, place)
        source_date = self.dataRoot.find('Cube').find('Cube').attrib['time']
        for item in self.dataRoot.find('Cube').find('Cube').findall('Cube'):
            source_quote_id = item.attrib["currency"]
            value = 1.0 / float(item.attrib['rate'].replace(',', '.'))
            price = self.default_map.make_price_date(source_quote_id, source_date, value)
            if price is not None:
                yield price


parsers.register("stocks3.parsers.ecb", EcbParser)
