# -*- coding: utf-8 -*-

"""
Парсим данные от ds.ifx.ru.
"""
import json
from stocks3.core.parser import Parser
from stocks3.core.factories import parsers


class InterfaxParser(Parser):

    def parse(self, place):
        content = json.loads(place.read())
        if len(content['Rows']) < 1:
            return []
        last_value = sorted(content['Rows'])[-1]
        yield self.default_map.make_price_date("MOEX Brent/USD", last_value[0], float(last_value[1]))

parsers.register("stocks3.parsers.interfax", InterfaxParser)


