# -*- coding: utf-8 -*-

"""
Базовый класс для всех JSON-парсеров.
"""
import json

from stocks3.core.parser import Parser
from stocks3.core.place import FilePlace

__author__ = "Bogdanov Evgeniy"
__email__ = "evbogdanov@yandex-team.ru"


class JSONParser(Parser):
    places = [FilePlace]

    def __init__(self, tree, node, source, config=None):
        Parser.__init__(self, tree, node, source, config=config)
        self.datatree = None
        self.data = None

    def parse(self, place):
        self.datatree = json.loads(place.read())
        self.data = self.datatree

    @staticmethod
    def findall():
        return []  # self.dataTree.findall(path)
