# -*- coding: utf-8 -*-

"""
Национальный банк Казахстана - парсим.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


from stocks3.parsers.xml import XMLParser
from stocks3.core.factories import parsers


class NationalBankKzParser(XMLParser):

    def parse(self, place):
        XMLParser.parse(self, place)
        for item in self.dataRoot.findall("channel/item"):
            sourceQuoteId = item.find("title").text
            sourceDate = item.find("pubDate").text
            value = float(item.find("description").text)
            price = self.default_map.make_price_date(sourceQuoteId, sourceDate, value)
            if price is not None:
                yield price


parsers.register("stocks3.parsers.NationalBankKz", NationalBankKzParser)


