# -*- coding: utf-8 -*-

"""
Парсер для nbrb.by.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


from stocks3.parsers.xml import XMLParser
from stocks3.core.factories import parsers


class NbrbByParser(XMLParser):
    # NOTE: здесь приходит scale

    def parse(self, place):
        XMLParser.parse(self, place)
        sourceDate = self.dataRoot.attrib["Date"]
        for node in self.dataRoot.findall("Currency"):
            sourceQuoteId = node.find("CharCode").text
            value = float(node.find("Rate").text)
            price = self.default_map.make_price_date(sourceQuoteId, sourceDate, value)
            if price is not None:
                yield price


parsers.register("stocks3.parsers.NbrbBy", NbrbByParser)


