# -*- coding: utf-8 -*-

"""
Парсим данные Национального Банка Украины
"""
from stocks3.parsers.jsonp import JSONParser
from stocks3.core.factories import parsers
from stocks3.share.db import DB_PRECISION


class NbuParser(JSONParser):
    def __init__(self, tree, node, source):
        self.tags = {}
        JSONParser.__init__(self, tree, node, source)

    def makeConfig(self):
        JSONParser.makeConfig(self)
        for tag in self.node.findall("tags/tag"):
            self.tags[tag.attrib["id"]] = {"buy": tag.attrib["buy"],
                                           "sell": tag.attrib["sell"]}

    def parse(self, place):
        JSONParser.parse(self, place)
        # source_date = str(self.datatree['time']['updatedISO']).split('+')[0]
        for q_item in self.datatree:
            source_date = q_item['exchangedate']
            value = round(float(q_item['rate']), DB_PRECISION)
            source_quote_id = q_item['cc']
            price = self.default_map.make_price_date(source_quote_id, source_date, value)
            if price is not None:
                yield price


parsers.register("stocks3.parsers.Nbu", NbuParser)
