# -*- coding: utf-8 -*-

"""
Парсим данные по биржевым курсам доллара и евро от rbc.ru
"""
from stocks3.parsers.jsonp import JSONParser
from stocks3.core.factories import parsers
from stocks3.share.db import DB_PRECISION


class RbcParser(JSONParser):

    def parse(self, place):
        JSONParser.parse(self, place)

        for quote_name, quote_value in self.data.items():
            source_date = quote_value['date']
            buy_value = round(float(quote_value['value']), DB_PRECISION)
            price = self.default_map.make_price_date(quote_name, source_date, buy_value)
            if price is not None:
                yield price


parsers.register("stocks3.parsers.rbc", RbcParser)
