# -*- coding: utf-8 -*-
"""
Парсер для Sedlabanki.is.
"""
from stocks3.core.parser import Parser
from stocks3.core.factories import parsers
import csv


class SedlabankiIsParser(Parser):
    def parse(self, place):
        f = place.read()
        reader = csv.reader(f.split('\n'), delimiter=";")
        for row in reader:
            if len(row) < 7:
                continue
            quote_id = row[2]
            quote_date = row[6]
            quote_value = float(row[7])
            price = self.default_map.make_price_date(quote_id, quote_date, quote_value)
            if price is not None:
                yield price


parsers.register("stocks3.parsers.sedlabankiis", SedlabankiIsParser)


