# -*- coding: utf-8 -*-

"""
    Тайландский центральный банк.
"""

from __future__ import print_function
__author__ = "Evgeny Bogdanov"
__email__ = "evbogdanov@yandex-team.ru"

from stocks3.core.factories import parsers
from stocks3.core.place import FilePlace
from stocks3.core.parser import Parser
import re


class ThailandRSS(Parser):
    def __init__(self, tree, root, source):
        self.data = ''
        Parser.__init__(self, tree, root, source)

    def makeConfig(self):
        Parser.makeConfig(self)

    def parse(self, place):
        Parser.parse(self, place)
        self.data = place.read()
        source_date = re.search(r'<dc:date>(\d\d\d\d-\d\d-\d\d)</dc:date>', self.data, re.UNICODE).groups()[0]

        for i in [1]:
            try:
                quote_id = re.search(r'<cb:baseCurrency>(.*)</cb:baseCurrency>', self.data, re.UNICODE).groups()[0]
                # можно поменять на targetCurrency
                #  = re.search(r'<cb:targetCurrency>(.*)</cb:targetCurrency>', self.data, re.UNICODE).groups()[0]
                value = float(re.search(r'>([\d.]*)</cb:value>', self.data, re.UNICODE).groups()[0])
            except KeyError:
                # FIXME: очень трудно будет понять, почему не работает парсер
                continue
            price = self.default_map.make_price_date(quote_id, source_date, value)
            if price is not None:
                yield price


parsers.register("stocks3.parsers.ThailandRSS", ThailandRSS)

