# -*- coding: utf-8 -*-

"""
Парсер данных, приходящих от transitcard.ru.
"""

from stocks3.parsers.xml import XMLParser
from stocks3.core.factories import parsers
__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


disabled_regions = [
    11353,
]


class TransitcardParser(XMLParser):
    def parse(self, place):
        XMLParser.parse(self, place)
        for regions in self.dataRoot.findall("regions"):
            source_date = regions.attrib["date"]
            for region in regions.findall("region"):
                region_id = int(region.attrib["id"])
                if region_id in disabled_regions:
                    continue
                for quoteNode in region:
                    # Узнаем идентификатор котировки
                    source_quote_id = quoteNode.tag
                    # Создаем котировку
                    value = float(quoteNode.text)
                    price = self.default_map.make_price_date(source_quote_id, source_date, value)
                    if price is not None:
                        price.onlyForRegion(region_id)
                        yield price


parsers.register("stocks3.parsers.Transitcard", TransitcardParser)
