# -*- coding: utf-8 -*-

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


from stocks3.parsers.xml import XMLParser
from stocks3.core.factories import parsers
from stocks3.share.geo import get_countries


class TransitcardCountriesParser(XMLParser):
    def makeConfig(self):
        XMLParser.makeConfig(self)
        self.countries_file = self.readString("", "geo")
        self.countries = get_countries(self.countries_file)

    def parse(self, place):
        XMLParser.parse(self, place)
        for regions in self.dataRoot.findall("countries"):
            source_date = regions.attrib["date"]
            for region in regions.findall("country"):
                if "id" not in region.attrib:
                    continue
                region_id = self.countries[region.attrib["id"]]
                for quoteNode in region:
                    # Узнаем идентификатор котировки
                    source_quote_id = quoteNode.tag
                    # Создаем котировку
                    value = float(quoteNode.text)
                    price = self.default_map.make_price_date(source_quote_id, source_date, value)
                    if price is not None:
                        price.onlyForRegion(region_id)
                        yield price


parsers.register("stocks3.parsers.TransitcardCountries", TransitcardCountriesParser)

