# -*- coding: utf-8 -*-

"""
Разбор котировок с турецким золотом.
"""
from __future__ import print_function

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"

from stocks3.parsers.xml import XMLParser
from stocks3.core.factories import parsers
from datetime import datetime


class TurkeyGoldParser_bysell(XMLParser):
    """
    Разбор данных вида:
        - LIST.VERILER.
            - GOLD_GR
            - GOLD_ONS
            - GOLD_CUMPHURIYET

    Внутри каждого узла:
        - ALIS - покупка (получается дилером)
        - SATIS - продажа (получается дилером)
        - ONCEKI - предыдущее
        - DEG - что-то непонятно
        - UPDOWN - что-то неизвестное
        - TARIH - похоже на Unixtime

    Смотрел на сайте - SATIS > ALIS.
    """
    def makeConfig(self):
        XMLParser.makeConfig(self)
        self.tarih_is_unixtime = self.readBool("", "tarih-is-unixtime", False)
        self.tags = {}
        for tag in self.node.findall("tags/tag"):
            self.tags[tag.attrib["id"]] = {"buy": tag.attrib["buy"],
                                           "sell": tag.attrib["sell"]}

    def parse(self, place):
        XMLParser.parse(self, place)
        for goldInfo in self.dataRoot.find("VERILER"):
            sourceQuoteId = goldInfo.tag
            try:
                buy_value = float(goldInfo.find(self.tags[sourceQuoteId]["sell"]).text.replace(",", "."))
                sell_value = float(goldInfo.find(self.tags[sourceQuoteId]["buy"]).text.replace(",", "."))
            except KeyError:
                # FIXME: очень трудно будет понять, почему не работает парсер
                continue
            #buy_value = float(goldInfo.findtext("ONCEKI").replace(",", "."))
            tarih = goldInfo.findtext("TARIH")
            if self.tarih_is_unixtime:
                sourceUnixtime = float(tarih)
                sourceDatetime = datetime.fromtimestamp(sourceUnixtime)
            else:
                sourceDatetime = self.default_map.strptime(sourceQuoteId, tarih)
            price = self.default_map.make_dual_price(sourceQuoteId, sourceDatetime, buy_value, sell_value)
            if price:
                yield price

parsers.register("stocks3.parsers.TurkeyGold_buysell", TurkeyGoldParser_bysell)

