# -*- coding: utf-8 -*-

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"

"""
Турецкая гривна из
    http://www.tcmb.gov.tr/bilgiamackur/201201/03012012.xml
"""

from stocks3.parsers.xml import XMLParser
from stocks3.core.factories import parsers


class TurkeyUAHParser(XMLParser):

    def parse(self, place):
        XMLParser.parse(self, place)

        tree = self.dataTree
        row_nodes = tree.findall('Currency')
        sourceDatetime = tree.getroot().attrib["Date"]
        for row in row_nodes:
            sourceQuoteId = row.attrib["Kod"]
            # Разбираем время и получаем значение котировки
            value = float(row.find('ExchangeRate').text)
            price = self.default_map.make_price_date(sourceQuoteId, sourceDatetime, value)
            if price is not None:
                yield price


parsers.register("stocks3.parsers.TurkeyUAH", TurkeyUAHParser)

