# -*- coding: utf-8 -*-

"""
Парсим данные по биткойнам от биржи WEX.nz
"""
from stocks3.parsers.jsonp import JSONParser
from stocks3.core.factories import parsers
from stocks3.share.db import DB_PRECISION
from datetime import datetime

__author__ = "Bogdanov Evgeniy"
__email__ = "evbogdanov@yandex-team.ru"


class WexBitcoinParser(JSONParser):
    def makeConfig(self):
        JSONParser.makeConfig(self)
        # self.tags = {}
        # for tag in self.node.findall("tags/tag"):
        #     self.tags[tag.attrib["id"]] = {"buy": tag.attrib["buy"],
        #                                    "sell": tag.attrib["sell"]}

    def parse(self, place):
        JSONParser.parse(self, place)

        source_date = datetime.now()
        for key, value in self.datatree.items():
            source_quote_id = key
            buy_value = round(float(value['avg']), DB_PRECISION)
            price = self.default_map.make_price(source_quote_id, source_date, buy_value)
            if price is not None:
                yield price


parsers.register("stocks3.parsers.WexBitcoin", WexBitcoinParser)
