# -*- coding: utf-8 -*-
"""
Базовый класс для всех XML-парсеров.
"""
from stocks3.core.parser import Parser
from stocks3.core.config import parse_xml_fromstring
from stocks3.core.place import MongoPlace
from libs import xmltodict


class XMLParser(Parser):

    places = [MongoPlace]

    def __init__(self, tree, node, source):
        Parser.__init__(self, tree, node, source)
        self.dataTree = None
        self.dataRoot = None

    def parse(self, place):
        Parser.parse(self, place)
        self.dataTree = parse_xml_fromstring(place.read())
        self.dataRoot = self.dataTree.getroot()

    def findall(self, path):
        return self.dataTree.findall(path)


class NewXMLParser(Parser):
    places = [MongoPlace]

    def __init__(self, tree, node, source):
        Parser.__init__(self, tree, node, source)
        self.data = {}

    def parse(self, place):
        self.data = xmltodict.parse(place.read())

