# -*- coding: utf-8 -*-

"""
Калькулятор, который вычисляет дельты.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"

from stocks3.core.factories import qcalculators
from stocks3.export.qcalculator import QCalculator


class DeltaCalculator(QCalculator):

    def process(self, quote, allprices):
        """
        Обрабатываем котировки.
        """
        calculated = {}
        for region, prices in allprices.items():
            if len(prices) == 0:
                # Пропускаем пустые списки
                continue

            is_first = True

            calculated_prices = []
            # Пробегаем по всем значениям, отсекая последнее.
            for i in range(len(prices)-1):
                # FIXME: мне не нравится, что здесь выполняется scale
                # И правильно не нравилось - не масштабируются графики (PNG)!
                orig_price = prices[i]
                calc_is_hot = is_first
                if is_first:
                    # На следующей итерации не надо будет масштабировать это
                    # значение, так как оно следующее :)
                    orig_price = self.scale_price(orig_price)
                    is_first = False
                orig_previous = self.scale_price(prices[i+1])
                self.save_value(orig_price, "previous", orig_previous)
                # calc_is_hot нужна для того, чтобы вычислять флаг is_hot только для первого значения в списке
                # для остальных значений is_hot устанавливается в 0, но delta_flag вычисляется.
                price = self.construct_price(quote, orig_price, self.precisions, calc_is_hot)
                calculated_prices.append(price)

            # Последнее значение у нас вычисляется особенным образом:
            # дельты для него всегда 0
            # FIXME: self.history_length is None - плохое условие
            if self.history_length is None or len(prices) <= self.history_length:
                # Корректирем последнее значение (оно тоже пойдет в экспорт)
                orig_last_value = prices[-1]
                # Масштабируем единственное значение! В предыдущем цикле оно не смасштабируется.
                if len(prices) == 1:
                    orig_last_value = self.scale_price(orig_last_value)
                self.save_value(orig_last_value, "previous", None)
                last_value = self.construct_price(quote, orig_last_value, self.precisions)
                calculated_prices.append(last_value)

            calculated[region] = calculated_prices

        self.run_templaters(quote, calculated)

    def calc(self, quote):
        QCalculator.calc(self, quote)
        # Выбираем на одно значение больше, чем требуется для экспорта
        # Это нужно для нормального расчета дельт
        for quote_for_process, allprices in self.read(quote):
            self.process(quote_for_process, allprices)


qcalculators.register("stocks3.qcalculators.Delta", DeltaCalculator)
