# -*- coding: utf-8 -*-

"""
Просто отдает прочитанные значения шаблонизатору.
"""
from stocks3.export.qcalculator import QCalculator
from stocks3.core.factories import qcalculators

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


class SimpleQCalculator(QCalculator):

    def process(self, quote, allprices):
        # FIXME: Переделать калькуляторы!!! Вынести calc выше

        calculated = {}
        # FIXME: Пересмотреть QCalculator
        for region, prices in allprices.items():
            l = []
            for price in prices:
                scaled_price = self.scale_price(price)
                c_price = self.run_calculators(quote.source, scaled_price)
                l.append(c_price)
            calculated[region] = l
        self.run_templaters(quote, calculated)

    def read(self, quote):
        # Читаем ровно столько, сколько попросили, а не +1 как в QCalculator
        return self.reader.read(self.history_length, quote, self.desc)

    def calc(self, quote):
        QCalculator.calc(self, quote)
        for quote_for_process, allprices in self.read(quote):
            self.process(quote_for_process, allprices)


qcalculators.register("stocks3.qcalculators.Simple", SimpleQCalculator)
