# -*- coding: utf-8 -*-
from stocks3.core.factories import readers
from stocks3.core.withdbconfig import WithDBConfiguration
# FIXME: избавиться от этих связей здесь и в db-saver'e
from stocks3.share.db import Database

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


class DBReader(WithDBConfiguration):
    """
    Умеет читать данные из базы данных.
    """

    def __init__(self, tree, node, exporter):
        self.not_use_unixtime = False
        WithDBConfiguration.__init__(self, tree, node)
        self.db = Database(self.get_dbinfo(),  self.not_use_unixtime)

    def makeConfig(self):
        WithDBConfiguration.makeConfig(self)
        self.not_use_unixtime = self.readBool("", "not-use-unixtime", False)

    def read(self, count, quotes, desc=True):
        data = self.db.read_from_db(count, quotes, desc)
        yield data


readers.register("stocks3.readers.DB", DBReader)

