# -*- coding: utf-8 -*-

"""
Вычисляем обратную котировку.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


from stocks3.readers.db import DBReader
from stocks3.share.reversequote import WithReverse


class ReverseDBReader(DBReader):
    def makeConfig(self):
        DBReader.makeConfig(self)
        self.reverse = WithReverse(self.tree, self.node, self.exporter)

    def is_reverse(self, quote):
        return self.reverse.is_reverse(quote)

    def read_reverse(self, quote, prices):
        return self.reverse.calc_reverse(quote, prices)

