# -*- coding: utf-8 -*-

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"

from stocks3.core.saver import Saver
from stocks3.core.factories import savers


class TestSaver(Saver):
    def __init__(self, tree, node, source):
        Saver.__init__(self, tree, node, source)
        self.db = object()

    def save(self, data):
        Saver.save(self, data)
        print("Saver price...")
        print(data.quote.quote_id, data.date, data.value)
        print(data.numeratorCost())
        print(data.denominatorCost())
        if hasattr(data, "unixtime"):
            print(data.unixtime)
        print("=="*40)


savers.register("stocks3.savers.Test", TestSaver)

