# -*- coding: utf-8 -*-

"""
Для автоматической загрузки скриптов.

Использовать:
# >>> from stocks3.autoload import autoload
# >>> autoload(__package__, __file__)
"""

import os
__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


def autoload(package, init_path):
    path = os.path.dirname(os.path.abspath(init_path))
    for module in filter(lambda x: x.endswith(".py") and x != "__init__.py", os.listdir(path)):
        # print(init_path, path, module[:-3])
        # print(package + '.' + module[:-3])
        pkg = __import__(package + '.' + module[:-3])   # -3 - отсекаем .py
        # print(pkg)

