# -*- coding: utf-8 -*-

"""
Из-за проблемы с кодировками в Cheetah для Python 2.5 пришлось написать эту функцию.

Используется в ExportableQuotes.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


import sys
import Cheetah
import Cheetah.Template
import xml.sax.saxutils
import Cheetah.Filters


def cheetah_decode(s):
    if type(s) == str:
        return s
    else:
        return unicode(s).encode("utf-8")

# class for filtering xml output
if sys.version_info < (2,6):
    class EscapeFilter(Cheetah.Filters.Filter):
        def filter(self, val, **kw):
            return xml.sax.saxutils.escape(str(val))
else:
    class EscapeFilter(Cheetah.Filters.Filter):
        def filter(self, val, **kw):
            return xml.sax.saxutils.escape(cheetah_decode(val))

def cheetah_template(template, searchList):
    """
    Базовые настройки шаблона Cheetah создает он.
    """
    return Cheetah.Template.Template(file=template, searchList=searchList, filter=EscapeFilter)

def run_cheetah(template):
    return str(template)

