# -*- coding: utf-8 -*-

"""
Дополнительные функции для работы с конфигурационноыми файлами.
"""
import os
from stocks3.core.default import Default
from stocks3.core.config import parse_xml
from stocks3.core.factories import sources


__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"

# Стандартный конфигурационный файл.
# FIXME: этот параметр дублируется в модулях.
DEFAULT_XML = "config/default-db.xml"


def load_sources(sources_files):
    """
    Загружает источники из файлов sources_files.
    """
    sources = []
    for xmlFile in sources_files:
        source = make_source_with_file(xmlFile)
        sources.append(source)
    return sources


def list_of_sources(sources_dir):
    """
    Генератор. Загружает информацию об источниках, расположенных в
    директории root.

    @param sources_dir: Путь до директории с конфигурационными файлами.
    """
    return load_sources(map(lambda x: os.path.join(sources_dir, x), find_config_files(sources_dir)))


def load_standart_default():
    """
    Загружает default.xml, прописанный по умолчанию.
    """
    global DEFAULT_XML
    return Default(DEFAULT_XML)

