# -*- coding: utf-8 -*-

"""
Помогает нам работать с базой данных.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


from stocks3.share.db import Database


class DBHelper:
    def __init__(self, db):
        assert isinstance(db, Database)
        self.db = db

    def read_from_db(self, count, quote, desc):
        """
        Читает count значений из базы данных для котировки quote.
        Сортирует исходя из флажка desc.
        """
        regions = self.db.select_regions(quote)
        prices = {}
        for region in regions:
            values = self.db.select_prices(quote, region, count, desc)
            if len(values) != 0:
                prices[region] = values
        return quote, prices

