# -*- coding: utf-8 -*-

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


from stocks3.core.config import etree
import sys


try:
    import tidylib
    from tidylib import tidy_document
except ImportError:
    # FIXME: закомментировал, чтобы не создавало проблем в логах
    #sys.stderr.write("Please, install pytidylib: easy_install pytidylib\n")
    tidylib = None

def minimize(xml):
    document, errors = tidy_document(xml, options={'output_xml':1, 'wrap': 0, 'indent':0, 'input_xml':1})
    if len(errors) != 0:
        raise RuntimeError("XML minimization failed: %s" % errors)
    return document

