# -*- coding: utf-8 -*-

"""
Модуль работает с гео-информацией.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


import csv


def get_countries(filename):
    """
    Загружает словарь для отображения идентификаторов стран в идентификаторы
    регионов геобазы.
    """
    countries = {}
    f = open(filename)
    try:
        reader = csv.reader(f, delimiter=";")
        for country, geo_id in reader:
            countries[country] = int(geo_id)
    finally:
        f.close()
    return countries




