# -*- coding: utf-8 -*-
"""
Иногда при пострении экспорта требуется фильтровать регионы (то есть в экспорт
могут пропускаться или непропускаться значения для заданных регионов).
"""

from . import messages
from .curl import load_url_data_retry
import os
import json
from functools import lru_cache
_cache = lru_cache(maxsize=100)


EARTH = 0
COUNTRY_TYPE = 3


geobase_api_base = "http://geobase.qloud.yandex.ru/v1/"
Authorization = "morda_stocks"


@_cache
def get_region(region: int):
    url = "{api_base}region_by_id?id={region}".format(api_base=geobase_api_base, region=region)
    return json.loads(load_url_data_retry(url, additional_headers=[('Authorization', Authorization)]).decode('utf-8'))


@_cache
def get_nearest_country(region: int):
    r = get_region(region)
    while r is not None and r['id'] != EARTH:
        if r['type'] == COUNTRY_TYPE:
            return r
        else:
            r = get_region(r['parent'])
    return None


@_cache
def get_region_name(region: int):
    r = get_region(region)
    if r is None:
        return None
    else:
        return r['enname']


@_cache
def is_subregion(child: int, parent: int):
    """
    Определяет, является ли регион child подрегионом региона parent.
    """
    url = "{api_base}in?pid={parent}&id={child}".format(api_base=geobase_api_base, parent=parent, child=child)
    return json.loads(load_url_data_retry(url, additional_headers=[('Authorization', Authorization)]).decode('utf-8'))

