# -*- coding: utf-8 -*-

"""
Модуль, который умеет ставить блокировки для недопущения запуска двух экземпляров скрипта
"""
import os
import sys


__author__ = "Bogdanov Evgeniy"
__email__ = "evbogdanov@yandex-team.ru"


class Locker(object):

    def __init__(self):
        self._scriptname = sys.argv[0][sys.argv[0].rfind('/') + 1:]
        self._filename = "/var/lock/" + self._scriptname + ".lock"
        pass

    def try_lock(self):
        if not self.locked:
            return self.lock()

    def check_state(self):
        try:
            with open(self._filename, "r") as f:
                pid = int(f.read())
                proc_group = os.getpgid(pid)
                return True
        except ProcessLookupError as e:
            #  В файле записан неправильный pid
            return False
        except IOError as e:
            # Не открыли файл - нет лока
            return False
        except ValueError as e:
            # Не прочитали pid из файла? значит там чушь - нет лока
            return False
    locked = property(check_state)

    def lock(self):
        try:
            with open(self._filename, "w+") as pidfile:
                pidfile.write(str(os.getpid()))
            return True
        except IOError:
            return False

    def unlock(self):
        try:
            os.remove(self._filename)
        except IOError:
            pass


locker = Locker()
