# -*- coding: utf-8 -*-

"""
Просто общие функции для нормализации значений котировок.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


from stocks3.core.quotesconfig import QuotesConfig


def load_normalization_list(node, quotes_config):
    """
    Загружает список нормализуемых котировок.
    """
    assert isinstance(quotes_config, QuotesConfig), "For load_normalization_list expected QuotesConfig."
    normalization = {}
    for quote_node in node.findall("normalization/quote"):
        quote_name = quote_node.attrib["name"]
        quote = quotes_config.getQuote(quote_name)
        normalization[quote.quote_id] = True
    return normalization

