# -*- coding: utf-8 -*-

"""
Функция для построения карты Котировка->Активный источник.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


def get_quote_source_map(sources):
    """
    Определяем, в каком источнике - какая котировка.
    """
    map_ = {}
    for source in sources:
        names = source.getImportQuotesNames()
        for name in names:
            if name in map_:
                current_source = map_[name]
                if current_source.weight < source.weight:
                    map_[name] = source
                elif current_source.weight == source.weight:
                    raise RuntimeError("Source-weight collision for %s: %s vs %s." % (
                            name, current_source.sourceId, source.sourceId))
            else:
                map_[name] = source
    return map_


def get_quote_source_multimap(sources):
    """
    Определяем, соответствие котировка -> источники.
    """
    _map = {}
    for source in sources:
        names = source.getImportQuotesNames()
        for name in names:
            if name not in _map:
                _map[name] = []
            _map[name].append(source)
    return _map

