# -*- coding: utf-8 -*-

"""
Сохранение файла через промежуточный файл.
"""
import os
import shutil
import tempfile
import codecs

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


def with_temp(full_filename, handler, *args, **kwargs):
    """
    Запускает обработчик handler, передав ему координаты временнго файла и
    аргументы args.
    """
    # Создаем временный файл. Он нужен для того, чтобы снаружи не было
    # видно временных изменений.
    fd, tmp = tempfile.mkstemp(kwargs.get("suffix", "stocks3_tempfile"))
    try:
        res = handler(fd, tmp)
        # Создаем директорию, в которой будет лежать выходной файл.
        target_directory = os.path.dirname(full_filename)
        try:
            os.makedirs(target_directory)
        except OSError:
            pass
        # Переносим файл на постоянное место.
        shutil.move(tmp, full_filename)
    except:
        os.unlink(tmp)
        raise
    # Устанавливаем новый режим
    os.chmod(full_filename, 0o644)
    return res


def save_through_tmp(output_directory, output_filename, data, suffix="stocks3_tempfile"):
    """
    Сохраняем данные через временный файл.
    """
    full_filename = os.path.join(output_directory, output_filename)

    def save_data(fd, tmp):
        with codecs.open(tmp, encoding='utf-8', mode="w+") as f:
            f.write(data)

    return with_temp(full_filename, save_data, data)
