# -*- coding: utf-8 -*-

"""
Функции для масштабирования значений при экспорте.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


from stocks3.core.config import str_to_bool


def load_scale_information(node, quotes_config):
    """
    Узнаем, как масштабировать при экспорте.
    """
    scales = {}
    for quote_node in node.findall("scale/quote"):
        quote_name = quote_node.attrib["name"]
        quote = quotes_config.getQuote(quote_name)
        scale_from_quote = str_to_bool(quote_node.attrib.get("scale-from-quote", "False"))
        if not scale_from_quote:
            scale = float(quote_node.attrib["scale"])
        else:
            scale = None
        scales[quote.quote_id] = {"from_quote": scale_from_quote, "scale": scale}
    return scales

