# -*- coding: utf-8 -*-

"""
Мгновенно выводит одну котировку на печать.
"""

from stocks3.export.templater import Templater
from stocks3.core.factories import templaters
from stocks3.share.timezone import get_timezone_fixed
import pytz
from datetime import datetime

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


def sign(num):
    return 1 if num >= 0 else -1


class ItemTemplater(Templater):
    TEMPFILE_SUFFIX = "stocks3_item_templater"

    def push(self, quote, data):
        Templater.push(self, quote, data)
        tz = get_timezone_fixed(quote, quote.source)
        offset = datetime.now(pytz.timezone(tz)).strftime('%z')
        offset_hours = str(int(offset[0:3]))
        offset_minutes = str(sign(int(offset[0:3])) * int(offset[3:]))
        for region, prices in data.items():
            output_filename = self.get_output_file_name(quote, region)
            if self.check_if_need_update_file(output_filename, prices):
                ns = self.make_default_env()
                ns.update({"quote": quote,
                           "prices": prices,
                           "tz": tz,
                           "offset_hours": offset_hours,
                           "offset_minutes": offset_minutes})
                self.save_through_tmp(ns, output_filename)


templaters.register("stocks3.templaters.Item", ItemTemplater)
