# -*- coding: utf-8 -*-

"""
Выводим графики.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"

from stocks3.export.templater import Templater
from stocks3.core.factories import templaters
from stocks3.share.morda_graph import Graph2File


class PngTemplater(Templater):
    def makeConfig(self):
        Templater.makeConfig(self)
        self.records_count = self.readInt("", "records-count")
        self.small_template = self.readString("", "small-template")
        self.big_template = self.filename_template

    def push(self, quote, data):
        graph = Graph2File(self)
        for region, prices in data.items():
            x = []
            y = [ [], [] ]
            not_dual = True
            start_index = len(prices) - self.records_count
            if start_index < 0:
                start_index = 0
            for price in prices[start_index:]:
                x.insert(0, price.date.date())
                y[0].insert(0, price.buy.value)
                if price.is_dual_price:
                    not_dual = False
                    y[1].insert(0, price.sell.value)
                else:
                    y[1].insert(0, 0.0)
            if not_dual:
                y = y[:1]
            graph.draw(quote, x, y, region)


templaters.register("stocks3.templaters.PNG", PngTemplater)

