# -*- coding: utf-8 -*-

"""
Специальный транспорт для finam.ru. Создан из-за ужасности самого запроса к
finam.ru (его нужно собирать по кусочкам).
"""

from __future__ import print_function

from datetime import datetime
from time import sleep

from stocks3.config.finam import FinamConfig
from stocks3.core.factories import transports
from stocks3.core.utils import force_decode
from stocks3.core.transport import Transport
from stocks3.share import messages
from stocks3.share.curl import load_url_data

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


class FinamTransport(Transport):
    def __init__(self, tree, node, source):
        self.quotes = []
        Transport.__init__(self, tree, node, source)
        self.config = FinamConfig(self.source.default.finam_config)
        # print('__init__')
        # traceback.print_stack()

    def makeConfig(self):
        Transport.makeConfig(self)
        # print('__makeconfig__')
        # traceback.print_stack()
        for quote in self.node.findall("get/quote"):
            name = quote.attrib["name"]
            quote_id = quote.attrib["id"]
            market = quote.attrib["market"]
            self.quotes.append((market, name, quote_id))

    def transfer(self, place):
        Transport.transfer(self, place)
        try:
            # Читаем список котировок, которые нужно бы забрать.
            today = datetime.today()
            result = ''
            for market, name, quote_id in self.quotes:
                url = self.config.prepareURL(market, name, quote_id, today, today)
                try:
                    data = load_url_data(url, can_be_empty=True)
                    result += force_decode(data)
                except Exception as e:
                    # FIXME: очень плохо, что здесь используется messages.error
                    # messages.error("ERROR: %s: finam: %s" % (self.__class__.__name__, str(e)))
                    pass
                # Костыль - у финама появился странный антиспам
                sleep(0.6)
            place.store(result)
        except Exception as e:
            print("Exception in finam.py:", e)


transports.register("stocks3.transports.Finam", FinamTransport)
