# -*- coding: utf-8 -*-

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"

""""
Турекций транспорт.

Впервые возникла неоходимость, когда турки дали нам такой во адрес экспорты:
    http://www.tcmb.gov.tr.bilgiamaclikur/YYYYMM/DDMMYYYY.xml

Это прибавило мне уверенности в мысле: "надо делать слабосвязные системы и
избавиться от ООПе".
"""

from .http import HTTPTransportWithDateTime
from stocks3.core.factories import transports


class TurkeyHTTP(HTTPTransportWithDateTime):
    def makeConfig(self):
        HTTPTransportWithDateTime.makeConfig(self)
        self.url = self.url.replace("%{ym}", self.today.strftime("%Y%m"))


transports.register("stocks3.transports.TurkeyHTTP", TurkeyHTTP)

