# -*- coding: utf-8 -*-

"""
Получаем данные по XML-RPC.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


from stocks3.core.transport import Transport
from stocks3.core.place import FilePlace, TempFile
from xmlrpc import client as xmlrpclib


class XmlRpcTransport(Transport):

    places = [FilePlace, TempFile]

    def makeConfig(self):
        Transport.makeConfig(self)
        self.url = self.readString("query", "url")

    def getProxy(self):
        """
        Создает прокси для подключения к XML-RPC серверу.
        """
        return xmlrpclib.ServerProxy(self.url, use_datetime=True)

