#!/bin/bash

# Этот скрипт забирает локализации из танкера и складывает в папочку ROOT.
# По умолчанию складывается в data, но можно указать любую директорию в первом
# параметре.

cd $(dirname $0)/..

TANKER_HOST=${2:-"tanker-api.yandex-team.ru"}
PROJECT_ID=stocks
KEYSET_ID=main
ROOT=${1:-data}

EXPORT_URL="https://${TANKER_HOST}/projects/export/xml/"
#TOKEN="Authorization: OAuth $(cat ./tanker/.token)"
TOKEN="Authorization: OAuth ${TANKER_TOKEN}"
JSON_EXPORT_URL="https://${TANKER_HOST}/projects/export/json/"
TMP_FILE=$(mktemp)
trap "rm -f ${TMP_FILE}" EXIT
TRANSLATION_DIR=${ROOT}/l10n/news/

[ -e ${TRANSLATION_DIR} ] || mkdir -p ${TRANSLATION_DIR}

echo "Downloading translation for quotes"
curl -s -H'Expect:' "${EXPORT_URL}?project-id=${PROJECT_ID}&keyset-id=${KEYSET_ID}&safe=ru" | xmllint -format - > ${TMP_FILE}
tanker/make-news-files.py ${TMP_FILE} ${TRANSLATION_DIR}

echo "Downloading translation for sources"
curl -s -H "${TOKEN}" \
    -H'Expect:' "${EXPORT_URL}?project-id=${PROJECT_ID}&keyset-id=sources&safe=ru" > ${TRANSLATION_DIR}/sources.xml
curl -s -H "${TOKEN}" \
    -H'Expect:' "${JSON_EXPORT_URL}?project-id=${PROJECT_ID}&keyset-id=sources&safe=ru" > ${TRANSLATION_DIR}/sources.json
