#!/bin/bash

cd $(dirname $0)/..

TANKER_HOST=${1:-tanker-api.yandex-team.ru}
PROJECT_ID=stocks
KEYSET_ID=main
LANGUAGE=ru

UPDATE_URL="https://${TANKER_HOST}/keysets/merge/"
TMP_FILE=$(mktemp)
TOKEN="Authorization: OAuth $(cat ./config/tanker.token)"
trap "rm -f ${TMP_FILE}" EXIT

echo -n | python3 tanker/totanker.py > ${TMP_FILE}

curl -s -H "${TOKEN}" \
     --form "keyset-id=${KEYSET_ID}" \
     --form "project-id=${PROJECT_ID}" \
     --form "format=xml" \
     --form language=${LANGUAGE} \
     --form file=@${TMP_FILE} \
     --header "Expect: " \
     ${UPDATE_URL}
