# coding: utf-8

"""
Скрипт, запускающий процесс обработки данных.

"""
import logging
import json
from datetime import datetime, timedelta
from pymongo import MongoClient, InsertOne
from pprint import pprint
import sys
import statistics
sys.path.append(".")

date_from = datetime.strptime("01.01.2020", "%d.%m.%Y")
date_to = datetime.strptime("26.07.2022", "%d.%m.%Y")


class Database:
    def __init__(self, connectionstring):
        self.client = MongoClient(connectionstring, readPreference='secondary')
        self.stocks = self.client.stocksdb.stocks


class FakeSource:
    weight = 50


def make_database_write(saver, query, on_date):
    if len(query) > 0:
        try:
            res = saver.stocks.bulk_write(query)
            print("date:", on_date.strftime("%Y-%m-%d"), "modified_count:", res.modified_count, "upserted_count:", res.upserted_count)
        except Exception as e:
            print("date:", on_date.strftime("%Y-%m-%d"), "insert error:", e)
    else:
        print("date:", on_date.strftime("%Y-%m-%d"), "skip inserts")


def process(source, db, logger):
    counter = 0
    query = []

    # 72015 - 'USD/AED'
    # 2002 - 'AED/RUB'
    # 2002 / 72015 => 72016 AED/RUB

    source1 = {}
    source2 = {}
    source3 = {}

    for s in db.stocks.find({"id": 2002, "date": {"$gt": date_from.strftime("%Y-%m-%d")}}):
        if s['date'] not in source1:
            source1[s['date']] = {}
        source1[s['date']] = s

    for s in db.stocks.find({"id": 72015, "date": {"$gt": date_from.strftime("%Y-%m-%d")}}):
        if s['date'] not in source2:
            source2[s['date']] = {}
        source2[s['date']] = s

    for s in db.stocks.find({"id": 72016, "date": {"$gt": date_from.strftime("%Y-%m-%d")}}):
        if s['date'] not in source3:
            source3[s['date']] = {}
        source3[s['date']] = s

    for v in source1.keys():
        if v not in source2:
            continue
        if v in source3:
            print("existing date, skipping", v)
            continue
        quote = {
            'id': 72016,
            'region': 0,
            'date': v,
            'unixtime': int(datetime.strptime(v, "%Y-%m-%d").timestamp()),
            'time': '00:00:00',
            'value': round(source1[v]['value']/source2[v]['value'], 4),
            'lastupdate': datetime.now(),
            'source': source.weight,
        }
        query.append(InsertOne(quote))

    print("len(query)", len(query))
    make_database_write(db, query, datetime.now())


def main():
    with open("config/config.json") as c:
        config = json.load(c)
        database = config["db"]["connectionstring"]
        # database = "prodmongo"
    logging.basicConfig(level=logging.WARNING)
    logger = logging.getLogger('IMPORT')
    db = Database(database)
    source = FakeSource()
    process(source, db, logger)


if __name__ == "__main__":
    main()
