# -*- coding: utf-8 -*-

"""
Выдает вообще все известные котировки в привязке к источникам.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


import sys
sys.path.append(".")
import stocks3
from stocks3.share.opts import Opts
from stocks3.share.timezone import get_timezone_fixed


def encode(s):
    if type(s) == str: return s.encode("utf-8")
    else: return s

if __name__ == "__main__":
    opts = Opts(sys.argv)
    stocks3.load_modules()
    selected_quotes = {}
    for name, source in opts.sources:
        for map_ in source.node.find("parser/id-maps"):
            if type(map_.tag) == str and len(map_.tag) != 0:
                for quoteNode in map_.findall("id"):
                    quoteName = quoteNode.attrib["to"]
                    try:
                        quote = opts.default.quotes_config.get_quote(quoteName)
                    except Exception:
                        continue

                    tz = get_timezone_fixed(quote, source)

                    if quote.quote_id not in selected_quotes or \
                       selected_quotes[quote.quote_id][1] < source.weight:
                        selected_quotes[quote.quote_id] = (name, source.weight, quote, quoteName, tz)
    for quoteId, values in selected_quotes.items():
        name, weigth, quote, quoteName, tz = values
        print(("%s@%s@%s@%s" % (name, quote.quote_id, encode(quoteName), tz)))

