# -*- coding: utf-8 -*-

"""
Конвертируем конфигурация Finam.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


import sys, os
sys.path.append(".")
from stocks3.core.config import parse_xml

if __name__ == "__main__":
    root_dir = "/opt/www/stocks2/config/finam.ru"
    quotes = {}
    for xml in filter(lambda f: not f.endswith(".prepare.xml") and f != ".svn", os.listdir(root_dir)):
        try:
            tree = parse_xml(os.path.join(root_dir, xml))
        except Exception:
            continue
        root = tree.getroot()
        name = root.find("url-params/short-name").attrib["val"]
        quote_id = root.find("url-params/id").attrib["val"]
        market = root.find("url-params/type").attrib["val"]
        quotes[name] = (quote_id, market)
    for name in sorted(quotes.keys()):
        quote_id, market = quotes[name]
        print('<quote name="%s" id="%s" market="%s"/>' % (name, quote_id, market))

