# -*- coding: utf-8 -*-

"""
Конвертируем карту id-map в новый формат.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


import sys, os
sys.path.append('.')
from stocks3.core.config import parse_xml
from stocks3.share.opts import Opts


if __name__ == "__main__":
    opts = Opts(sys.argv)

    for filename in sys.argv[1:]:
        tree = parse_xml(filename)
        root = tree.getroot()

        print('<!-- %s -->' % os.path.basename(filename))
        for item in root.findall("id-map/item"):
            from_ = item.attrib["from"]
            to = int(item.attrib["to"])
            name = opts.default.quotes_config.getQuoteName(to)
            print('<id from="%s" to="%s"/>' % (from_, name))
        print()

