#!/bin/bash

# Скрипт специально предназначен для сравнения экспортов.
# Алгоритм работы прост:
#  - пробегаемся по data и ищем соответствия нашим файлам в stocks2.
#    - может быть мы не найдем файлик, который у нас присутствует - выдаем его на экран;
#  - сравниваем каждый найденный файл командкой diff -u -b
#  - пробегаем по stocks2/data и ищем лишние файлы - выдаем на экран

STOCKS2=/opt/www/stocks2

#cd $(dirname `dirname $0`)
cd /opt/www/stocks2/stocks3

file_date() 
{
    stat -c %y $1 | sed 's/^\([0-9\-]*\).*/\1/'
}

is_later()
{
    DATE=$(date -d "$1" +%Y-%m-%d)
    TODAY=$(date -d "$(date +%Y-%m-%d) $2 $3" +%s)
    COMPARE=$(date -d "$DATE" +%s)
    test $(($TODAY - $COMPARE)) -le 0 && return 0 || return 1
}


# Ищем файлы, которых нет в нашем родном экспорте
for f in `find $STOCKS2/data | grep -v git | grep -v svn`; do
    tmp=$(readlink -e "$f")
    relative="."${tmp#$STOCKS2}
    d=`file_date $f`
    if [ ! -f $relative ]; then
        if is_later $d -3 week; then
            echo $relative
        fi
    fi
done


