# -*- coding: utf-8 -*-

"""
Получаем данные с Finam.

Использовать так:
    python utils/get_finam.py сырье ICE.BRN 19473
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


import sys
sys.path.append(".")
from stocks3.config.finam import FinamConfig
from stocks3.share.curl import load_url_data
from datetime import datetime


if __name__ == "__main__":
    argv = sys.argv
    config = FinamConfig("config/finam.xml")
    today = datetime.today()
    # Market ShortName QuoteID
    url = config.prepareURL(argv[1].decode("utf-8"), argv[2], argv[3], today, today)
    data = load_url_data(url)
    print data
